# INPUT:  A string in {a, b}*
# OUTPUT: Whether that string is a palindrome
#
# Checks if the input string is a palindrome. Works very similarly to the
# machine for a^nb^n: cross off the first character, see if it matches the
# last character, repeating until we're down to zero or one characters.

Start:
    # Check for length 0 or length 1
    If Blank Return True
    Move Right
    If Blank Return True
    Move Left
    
    # See what we're dealing with
    If 'a' Goto MatchA
    If 'b' Goto MatchB
    Return False # Unknown character?

# First character is a. confirm the last character is too.
MatchA:
    Write Blank
ToEndA:
    Move Right
    If Not Blank Goto ToEndA
    Move Left
    If Not 'a' Return False
    Write Blank
    Goto Rewind

# First character is b. confirm the last character is too.
MatchB:
    Write Blank
ToEndB:
    Move Right
    If Not Blank Goto ToEndB
    Move Left
    If Not 'b' Return False
    Write Blank
    Goto Rewind

# Matched first/last character; time to start over.
Rewind:
    Move Left
    If Not Blank Goto Rewind
    Move Right
    Goto Start
